﻿Option Strict Off
Module Trainermodul_64Bit
#Region "Deklarationen"
    Private process_id As Int32 = 0
    Private Const ACCESS_RIGHTS_ALL = &H1F0FFF

    Private Declare Function OpenProcess Lib "kernel32" (ByVal dwDesiredAccess As Int32, ByVal bInerhitHandle As Int32, ByVal dwProcessId As Int32) As Int32
    Private Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Int32) As Int32

    'API Lesefunktion 32Bit
    '1 Liest 1 Byte bis 127 Wert
    Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As SByte, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int32) As SByte
    '2 Liest 1 Byte bis 255 Wert
    Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Byte, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int32) As Byte
    '3 Liest 2 Byte bis 32767
    Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Int16, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int32) As Int16
    '4 Liest 2 Byte bis 65535
    Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As UInt16, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int32) As UInt16
    '5 Liest 4 Byte bis 2147483647 Wert
    Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Int32, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int32) As Int32
    '6 Liest 4 Byte bis 4294967295
    Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As UInt32, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int32) As UInt32
    '7 Liest 8 Byte bis 9223372036854775807
    Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Int64, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int32) As Int64
    '5. Liest Float Bytes
    Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Single, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int32) As Single
    '6. Liest Double Bytes
    Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Double, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int32) As Double

    ''5. Liest Float Bytes 64Bit noch experimentel
    'Private Declare Function RPM Lib "kernel32" Alias "ReadProcessMemory" (ByVal hProcess As Int64, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Single, ByVal nSize As Int64, ByRef lpNumberOfBytesWritten As Int64) As Single

    'API Schreibfunktion
    '1 Schreibt 1 Byte bis 127 Wert
    Private Declare Function WPM Lib "kernel32" Alias "WriteProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As SByte, ByVal nSize As Int32, ByRef lpNumberOfBytesWritten As Int32) As SByte
    '2 Schreibt 2 Byte bis 255 Wert
    Private Declare Function WPM Lib "kernel32" Alias "WriteProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Byte, ByVal nSize As Int32, ByRef lpNumberOfBytesWritten As Int32) As Byte
    '3 Schreibt 2 Byte bis 32767 Wert
    Private Declare Function WPM Lib "kernel32" Alias "WriteProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Int16, ByVal nSize As Int32, ByRef lpNumberOfBytesWritten As Int32) As Int16
    '4 Schreibt 2 Byte bis 65535 Wert
    Private Declare Function WPM Lib "kernel32" Alias "WriteProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As UInt16, ByVal nSize As Int32, ByRef lpNumberOfBytesWritten As Int32) As UInt16
    '4 Schreibt 4 Byte bis 2147483647 Wert
    Private Declare Function WPM Lib "kernel32" Alias "WriteProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Int32, ByVal nSize As Int32, ByRef lpNumberOfBytesWritten As Int32) As Int32
    '8 Schreibt 4 Byte bis 4294967295 Wert
    Private Declare Function WPM Lib "kernel32" Alias "WriteProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As UInt32, ByVal nSize As Int32, ByRef lpNumberOfBytesWritten As Int32) As UInt32
    '8 Schreibt 8 Byte bis 9223372036854775807 Wert
    Private Declare Function WPM Lib "kernel32" Alias "WriteProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Int64, ByVal nSize As Int32, ByRef lpNumberOfBytesWritten As Int32) As Int64
    '5. Schreibt Float Byte
    Private Declare Function WPM Lib "kernel32" Alias "WriteProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Single, ByVal nSize As Int32, ByRef lpNumberOfBytesWritten As Int32) As Single
    '6. Schreibt Double Byte
    Private Declare Function WPM Lib "kernel32" Alias "WriteProcessMemory" (ByVal hProcess As Int32, ByVal lpBaseAddress As Int64, ByRef lpBuffer As Double, ByVal nSize As Int32, ByRef lpNumberOfBytesWritten As Int32) As Double

    Private Declare Function VirtualAllocEx Lib "kernel32.dll" (ByVal hProcess As IntPtr, ByVal lpAddress As IntPtr, ByVal dwSize As IntPtr, ByVal flAllocationType As Integer, ByVal flProtect As Integer) As IntPtr
    Private Declare Function VirtualProtectEx Lib "kernel32.dll" (ByVal hProcess As IntPtr, ByVal lpAddress As IntPtr, ByVal dwSize As IntPtr, ByVal newProtect As Integer, ByRef oldProtect As Integer) As Boolean

    Public Declare Function IsDebuggerPresent Lib "KERNEL32" () As Boolean

#End Region

    'Hotkeys habe ich ins Trainermodul geschoben, um den eigentliche Trainercode sauber zu halten.
#Region "Hotkeys"
    Public Declare Function GetAsyncKeyState Lib "user32" (ByVal vkey As Long) As Integer
    Public Const VK_NUMPAD0 = &H60
    Public Const VK_NUMPAD1 = &H61
    Public Const VK_NUMPAD2 = &H62
    Public Const VK_NUMPAD3 = &H63
    Public Const VK_NUMPAD4 = &H64
    Public Const VK_NUMPAD5 = &H65
    Public Const VK_NUMPAD6 = &H66
    Public Const VK_NUMPAD7 = &H67
    Public Const VK_NUMPAD8 = &H68
    Public Const VK_NUMPAD9 = &H69
    Public Const VK_MULTIPLY = &H6A
    Public Const VK_ADD = &H6B
    Public Const VK_SUBSTRACT = &H6D
    Public Const VK_DIVIDE = &H6F
    Public Const VK_F1 = &H70
    Public Const VK_F2 = &H71
    Public Const VK_F3 = &H72
    Public Const VK_F4 = &H73
    Public Const VK_F5 = &H74
    Public Const VK_F6 = &H75
    Public Const VK_F7 = &H76
    Public Const VK_F8 = &H77
    Public Const VK_F9 = &H78
    Public Const VK_F10 = &H79
    Public Const VK_F11 = &H7A
    Public Const VK_F12 = &H7B
    Public Const VK_CONTROL = &H11
#End Region
    Public BaseAddress_32Bit_EXE As Int32
    Public BaseAddress_64Bit_EXE As Int64
    Public BaseAddress_32Bit_DLL As Int32
    Public BaseAddress_64Bit_DLL As Int64
    Public THREADSTACK1_32Bit As Int32
    Public THREADSTACK1_64Bit As Int64

    Public Function GetModuleBase_32Bit(ByVal ProcName As String, ByVal ModuleName As String)
        Dim BaseAddress As Int32
        For Each PM As ProcessModule In Process.GetProcessesByName(ProcName)(0).Modules
            If ModuleName.ToLower = PM.ModuleName.ToLower Then
                BaseAddress = PM.BaseAddress
            End If
        Next
        Return BaseAddress
    End Function

    Public Function GetModuleBase_64Bit(ByVal ProcName As String, ByVal ModuleName As String)
        Dim BaseAddress As Int64
        For Each PM As ProcessModule In Process.GetProcessesByName(ProcName)(0).Modules
            If ModuleName.ToLower = PM.ModuleName.ToLower Then
                BaseAddress = PM.BaseAddress
            End If
        Next
        Return BaseAddress
    End Function

    Public Function GetProcessId(ByVal ProcName As String)
        For Each Proc In Process.GetProcesses()
            If Proc.ProcessName = ProcName Then
                process_id = Proc.Id
            End If
        Next
        Return process_id
    End Function

#Region "Direkte Lesefunktion"
    'Liest 1 Byte
    'Beispiel: >>> gültigen variable O. TextBox.text  O. NumericUpDown.value hinter dem istzeichen = Read_1Byte_32Bit(&H123456) <<<
    Public Function Read_1Byte_32Bit(ByVal address As Int64) As SByte
        Dim process_handle As Int32, value As SByte
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 1, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    Public Function Read_1Byte_64Bit(ByVal address As Int64) As Byte
        Dim process_handle As Int32, value As Byte
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 1, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    'Liest 2 Bytes
    Public Function Read_2Byte_32Bit(ByVal address As Int64) As Int16
        Dim process_handle As Int32, value As Int16
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 2, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    Public Function Read_2Byte_64Bit(ByVal address As Int64) As UInt16
        Dim process_handle As Int32, value As UInt16
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 2, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    'Liest 3 Bytes
    Public Function Read_3Byte_32Bit(ByVal address As Int64) As Int32
        Dim process_handle As Int32, value As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 3, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    Public Function Read_3Byte_64Bit(ByVal address As Int64) As UInt32
        Dim process_handle As Int32, value As UInt32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 3, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    'Liest 4 Bytes
    Public Function Read_4Byte_32Bit(ByVal address As Int64) As Int32
        Dim process_handle As Int32, value As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 4, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    Public Function Read_4Byte_64Bit(ByVal address As Int64) As UInt32
        Dim process_handle As Int32, value As UInt32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 4, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    'Liest 8 Bytes
    Public Function Read_8Byte_32Bit(ByVal address As Int64) As Int64
        Dim process_handle As Int32, value As Int64
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 8, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    'Float Kommastellen auf oder abrunden auslesen
    Public Function Read_Float_32Bit_NoKomma(ByVal address As Int64) As Int32
        Dim process_handle As Int32, value As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 4, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    'Float Kommastellen auslesen
    Public Function Read_Float_32Bit_Komma(ByVal address As Int64) As Single
        Dim process_handle As Int32, value As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 4, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    'Double Ohne Kommastellen auslesen
    Public Function Read_Double_NOKomma(ByVal address As Int64) As Int32
        Dim process_handle As Int32, value As Double
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 8, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    Public Function Read_Double_Komma(ByVal address As Int64) As Double
        Dim process_handle As Int32, value As Double
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            RPM(process_handle, address, value, 8, 0)
        End If
        CloseHandle(process_handle)
        Return value
    End Function
    'Liest einen String
    Public Function Read_String(ByVal length As Int32, ByVal address As Int64)
        Dim value As Int32
        Dim str As String = ""
        For i = 0 To length - 1
            value = Read_1Byte_64Bit(address + i)
            str &= Convert.ToChar(value)
        Next
        Return str
    End Function
#End Region
#Region "Pointer Lesefunktion"
    'Pointer lesen
    'Beispiel: >>> gültigen variable O. TextBox.text  O. NumericUpDown.value hinter dem istzeichen = Read_Pointer_1Byte_32Bit(BaseAddress_EXE + &H123456, {&H123}) <<<
    'Liest 1 Bytes
    Public Function Read_Pointer_1Byte_32Bit(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            address = Read_1Byte_32Bit(address + Offset(Offset.Length - 1))
        Else
            address = Read_1Byte_32Bit(address)
        End If
        Return address
    End Function
    Public Function Read_Pointer_1Byte_64Bit(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            address = Read_1Byte_64Bit(address + Offset(Offset.Length - 1))
        Else
            address = Read_1Byte_64Bit(address)
        End If
        Return address
    End Function
    'Liest 2 Bytes
    Public Function Read_Pointer_2Byte_32Bit(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            address = Read_2Byte_32Bit(address + Offset(Offset.Length - 1))
        Else
            address = Read_2Byte_32Bit(address)
        End If
        Return address
    End Function
    Public Function Read_Pointer_2Byte_64Bit(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            address = Read_2Byte_64Bit(address + Offset(Offset.Length - 1))
        Else
            address = Read_2Byte_64Bit(address)
        End If
        Return address
    End Function
    'Liest 4 Bytes
    Public Function Read_Pointer_4Byte_32Bit(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        address = Read_4Byte_32Bit(address)
        If Not IsNothing(Offset) Then
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            address = Read_4Byte_32Bit(address + Offset(Offset.Length - 1))
        Else
            address = Read_4Byte_32Bit(address)
        End If
        Return address
    End Function
    Public Function Read_Pointer_4Byte_64Bit(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        address = Read_4Byte_32Bit(address)

        If Not IsNothing(Offset) Then
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            address = Read_4Byte_64Bit(address + Offset(Offset.Length - 1))
        Else
            address = Read_4Byte_64Bit(address)
        End If
        Return address
    End Function
    'Liest 8 Bytes
    Public Function Read_Pointer_8Byte_32Bit(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            address = Read_8Byte_32Bit(address + Offset(Offset.Length - 1))
        Else
            address = Read_8Byte_32Bit(address)
        End If
        Return address
    End Function
    'Liest 4Byte (Float)
    Public Function Read_Pointer_Float_NoKomma(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 1
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
        End If
        Return address
    End Function
    Public Function Read_Pointer_Float_Komma(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 1
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
        End If
        Return address
    End Function
    'Liest 8 Bytes (Double)
    Public Function Read_Pointer_Double_NoKomma(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 1
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
        End If
        Return address
    End Function
    Public Function Read_Pointer_Double_Komma(ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 1
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
        End If
        Return address
    End Function
    'Liest einen String
    Public Function Read_Pointer_String(ByVal length As Int32, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        Dim str As String = ""
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            str = Read_String(length, address + Offset(Offset.Length - 1))
        Else
            str = Read_String(length, address)
        End If
        Return str
    End Function
#End Region

#Region "Direkte Schreibfunktion"
    'Bitte drauf achten wenn es um Zahlen geht das die TextBox oder NumericUpDown Objekte nicht Leer sind mindestens 0 oder höher muss drin sein, sonst kommt Fehler
    'Beispiel: >>> Write Funktion Beispiel Write_1Byte_32Bit(&H123456, TextBox1.text) oder gültiger variablen oder direkte zahl <<<
    'Schreibt 1 Byte
    Public Sub Write_1Byte_32Bit(ByVal address As Int32, ByVal value As SByte)
        Dim process_handle As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            WPM(process_handle, address, value, 1, 0)
        End If
        CloseHandle(process_handle)
    End Sub
    Public Sub Write_1Byte_64Bit(ByVal address As Int32, ByVal value As Byte)
        Dim process_handle As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            WPM(process_handle, address, value, 1, 0)
        End If
        CloseHandle(process_handle)
    End Sub
    'Schreibt 2 Bytes
    Public Sub Write_2Byte_32Bit(ByVal address As Int32, ByVal value As Int16)
        Dim process_handle As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            WPM(process_handle, address, value, 2, 0)
        End If
        CloseHandle(process_handle)
    End Sub
    Public Function Write_2Byte_64Bit(ByVal address As Int32, ByVal value As UInt16)
        Dim process_handle As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            WPM(process_handle, address, value, 2, 0)
        End If
        Return process_handle
        CloseHandle(process_handle)
    End Function
    'Schreibt 4 Bytes
    Public Sub Write_4Byte_32Bit(ByVal address As Int32, ByVal value As Int32)
        Dim process_handle As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            WPM(process_handle, address, value, 4, 0)
        End If
        CloseHandle(process_handle)
    End Sub
    Public Sub Write_4Byte_64Bit(ByVal address As Int32, ByVal value As UInt32)
        Dim process_handle As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            WPM(process_handle, address, value, 4, 0)
        End If
        CloseHandle(process_handle)
    End Sub
    'Schreibt 8 Bytes
    Public Sub Write_8Byte_32Bit(ByVal address As Int32, ByVal value As Int64)
        Dim process_handle As Int32
        process_handle = OpenProcess(ACCESS_RIGHTS_ALL, False, process_id)
        If process_handle <> 0 Then
            WPM(process_handle, address, value, 8, 0)
        End If
        CloseHandle(process_handle)
    End Sub
    'Schreibt einen String
    Public Sub Write_String(ByVal address As Int32, ByVal value As String)
        Dim bytes(0) As Byte
        Dim i As Int32 = 0
        bytes = System.Text.Encoding.ASCII.GetBytes(value)
        For Each b As Byte In bytes
            Write_1Byte_32Bit(address + i, b)
            i += 1
        Next
        For l = i To 64
            Write_1Byte_32Bit(address + l, 0)
        Next
    End Sub

    Public Sub Write_TextfromString(ByVal address As Int32, ByVal value As Byte)
        Dim bytes(0) As Byte
        Dim i As Int32 = 0
        'bytes = System.Text.Encoding.Default.GetBytes(value)
        For Each b As Byte In bytes
            Write_1Byte_64Bit(address + i, b)
            i += 1
        Next
        For l = i To 64
            Write_1Byte_64Bit(address + l, 0)
        Next
    End Sub

    Public Sub autopatcher(ByVal address As Int32, ByVal value As Byte())
        Dim i As Byte
        For i = LBound(value) To UBound(value)
            Write_1Byte_32Bit(address + i, value(i))
        Next
    End Sub
#End Region
#Region "Pointer Schreibfunktion" 'Pointer schreiben
    'Bitte drauf achten wenn es um Zahlen geht das die TextBox oder NumericUpDown Objekte nicht Leer sind mindestens 0 oder höher muss drin sein, sonst kommt Fehler
    'Beispiel: >>> Write_Pointer_1Byte_32Bit(Zahl eingeben -> 255 O. TextBox.text  O. NumericUpDown.value hier hinter dem Komma, BaseAddress_EXE + &H123456, {&H123}) <<<
    'Schreibt 1 Bytes
    Public Function Write_Pointer_1Byte_32Bit(ByVal WhatToWrite As Int32, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_1Byte_32Bit(address + Offset(Offset.Length - 1), WhatToWrite)
        Else
            Write_1Byte_32Bit(address, WhatToWrite)
        End If
        Return address
    End Function
    Public Function Write_Pointer_1Byte_64Bit(ByVal WhatToWrite As Int32, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_1Byte_64Bit(address + Offset(Offset.Length - 1), WhatToWrite)
        Else
            Write_1Byte_64Bit(address, WhatToWrite)
        End If
        Return address
    End Function
    'Schreibt 2 Bytes
    Public Function Write_Pointer_2Byte_32Bit(ByVal WhatToWrite As Int32, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_2Byte_32Bit(address + Offset(Offset.Length - 1), WhatToWrite)
        Else
            Write_2Byte_32Bit(address, WhatToWrite)
        End If
        Return address
    End Function
    Public Function Write_Pointer_2Byte_64Bit(ByVal WhatToWrite As Int32, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_2Byte_64Bit(address + Offset(Offset.Length - 1), WhatToWrite)
        Else
            Write_2Byte_64Bit(address, WhatToWrite)
        End If
        Return address
    End Function
    'Schreibt 4 Bytes
    Public Function Write_Pointer_4Byte_32Bit(ByVal WhatToWrite As Int32, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_4Byte_32Bit(address + Offset(Offset.Length - 1), WhatToWrite)
        Else
            Write_4Byte_32Bit(address, WhatToWrite)
        End If
        Return address
    End Function
    Public Function Write_Pointer_4Byte_64Bit(ByVal WhatToWrite As Int32, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_4Byte_64Bit(address + Offset(Offset.Length - 1), WhatToWrite)
        Else
            Write_4Byte_64Bit(address, WhatToWrite)
        End If
        Return address
    End Function
    'Schreibt 8 Bytes
    Public Function Write_Pointer_8Bytes_32Bit(ByVal WhatToWrite As Int64, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_8Byte_32Bit(address + Offset(Offset.Length - 1), WhatToWrite)
        Else
            Write_8Byte_32Bit(address, WhatToWrite)
        End If
        Return address
    End Function
    'Schreibt 4 Byte (Float)
    Public Function Write_Pointer_Float(ByVal WhatToWrite As Single, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_4Byte_32Bit(address + Offset(Offset.Length - 1), Float2Long(WhatToWrite))
        Else
            Write_4Byte_32Bit(address, Float2Long(WhatToWrite))
        End If
        Return address
    End Function
    'Schreibt 8 Bytes (Double)
    Public Function Write_Pointer_Double(ByVal WhatToWrite As Double, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_8Byte_32Bit(address + Offset(Offset.Length - 1), DoubletoInt64(WhatToWrite))
        Else
            Write_8Byte_32Bit(address, DoubletoInt64(WhatToWrite))
        End If
        Return address
    End Function
    'Beispiel: >>> Write_Pointer_String(Zahl oder String eingeben O. TextBox.text  O. NumericUpDown.value hier hinter dem Komma, BaseAddress_EXE + &H123456, {&H123}) <<<
    'Schreibt einen String
    Public Function Write_Pointer_String(ByVal WhatToWrite As String, ByVal address As Int64, Optional ByVal Offset() As Int32 = Nothing)
        If Not IsNothing(Offset) Then
            address = Read_4Byte_32Bit(address)
            For i = 0 To Offset.Length - 2
                address = Read_4Byte_32Bit(address + Offset(i))
            Next
            Write_String(address + Offset(Offset.Length - 1), WhatToWrite)
        Else
            Write_String(address, WhatToWrite)
        End If
        Return address
    End Function
#End Region

#Region "Teleporter"
    'Die Teleporter Klassen
    Public Class Teleporter_32Bit
        Public XKoord_32Bit As Int32
        Public YKoord_32Bit As Int32
        Public ZKoord_32Bit As Int32
    End Class

    Public Class Teleporter_64Bit
        Public XKoord_64Bit As Int64
        Public YKoord_64Bit As Int64
        Public ZKoord_64Bit As Int64
    End Class
    'Liest die Koordinaten aus und gibt die Koordinaten per Klasse zurück.
    Public Function Read_Koord_32Bit(ByVal address As Int32, ByVal Offset As Int32, ByVal SMA As Boolean) As Teleporter_32Bit
        Dim Koord As New Teleporter_32Bit
        Dim KoordBase As Int32
        If SMA = 0 Then
            KoordBase = Read_4Byte_32Bit(address)
        ElseIf SMA = 1 Then
            KoordBase = address
        End If
        Koord.XKoord_32Bit = Read_4Byte_32Bit(KoordBase + Offset)
        Koord.YKoord_32Bit = Read_4Byte_32Bit(KoordBase + Offset + 4)
        Koord.ZKoord_32Bit = Read_4Byte_32Bit(KoordBase + Offset + 8)
        Return Koord
    End Function
    Public Function Read_Koord_64Bit(ByVal address As Int32, ByVal Offset As Int32, ByVal SMA As Boolean) As Teleporter_64Bit
        Dim Koord As New Teleporter_64Bit
        Dim KoordBase As Int32
        If SMA = 0 Then
            KoordBase = Read_4Byte_32Bit(address)
        ElseIf SMA = 1 Then
            KoordBase = address
        End If
        Koord.XKoord_64Bit = Read_4Byte_64Bit(KoordBase + Offset)
        Koord.YKoord_64Bit = Read_4Byte_64Bit(KoordBase + Offset + 4)
        Koord.ZKoord_64Bit = Read_4Byte_64Bit(KoordBase + Offset + 8)
        Return Koord
    End Function

    'Schreibt Koordinaten
    Public Function Write_Koord_32Bit(ByVal address As Int32, ByVal Offset As Int32, ByVal SMA As Boolean, ByVal Position As Teleporter_32Bit)
        Dim KoordBase As Int32
        If SMA = 0 Then
            KoordBase = Read_4Byte_32Bit(address)
        ElseIf SMA = 1 Then
            KoordBase = address
        End If
        Write_4Byte_32Bit(KoordBase + Offset, Position.XKoord_32Bit)
        Write_4Byte_32Bit(KoordBase + Offset + 4, Position.YKoord_32Bit)
        Write_4Byte_32Bit(KoordBase + Offset + 8, Position.ZKoord_32Bit)
        Return KoordBase
    End Function
    Public Function Write_Koord_64Bit(ByVal address As Int32, ByVal Offset As Int32, ByVal SMA As Boolean, ByVal Position As Teleporter_64Bit)
        Dim KoordBase As Int32
        If SMA = 0 Then
            KoordBase = Read_4Byte_32Bit(address)
        ElseIf SMA = 1 Then
            KoordBase = address
        End If
        Write_4Byte_64Bit(KoordBase + Offset, Position.XKoord_64Bit)
        Write_4Byte_64Bit(KoordBase + Offset + 4, Position.YKoord_64Bit)
        Write_4Byte_64Bit(KoordBase + Offset + 8, Position.ZKoord_64Bit)
        Return KoordBase
    End Function
#End Region

#Region "Memory Function"
    'Weist neuen, virtuellen Speicher zu und gibt die Startadresse zurück.
    Public Function AllocMem(ByVal ProcessName As String) As Integer 'Allocates memory in the process and returns the starting address of the allocated area
        Dim startaddress As IntPtr
        For Each p As Process In Process.GetProcessesByName(ProcessName)
            Const MEM_COMMIT As Integer = &H1000
            Const PAGE_EXECUTE_READWRITE As Integer = &H40
            Dim pBlob As IntPtr = VirtualAllocEx(p.Handle, New IntPtr(), New IntPtr(2048), MEM_COMMIT, PAGE_EXECUTE_READWRITE)
            If pBlob = IntPtr.Zero Then
                startaddress = 0
            Else : startaddress = pBlob
            End If
        Next
        Return startaddress
    End Function
    'Hebt den Speicherschutz auf.
    Sub RemoveProtection(ByVal ProcessName As String, ByVal AddressOfStart As Integer, ByVal SizeToRemoveProtectionInBytes As Integer)
        For Each p As Process In Process.GetProcessesByName(ProcessName)
            Const PAGE_EXECUTE_READWRITE As Integer = &H40
            Dim oldProtect As Integer
            If Not VirtualProtectEx(p.Handle, New IntPtr(AddressOfStart), New IntPtr(SizeToRemoveProtectionInBytes), PAGE_EXECUTE_READWRITE, oldProtect) Then Throw New Exception
            p.Dispose()
        Next
    End Sub
    'ByteSignature Scanner.
    Public Function SigScan(ByVal ProcName As String, ByVal ModuleName As String, ByVal Sig As Byte()) As Int32
        Dim BaseAddress, EndAddress As Int32
        For Each PM As ProcessModule In Process.GetProcessesByName(ProcName)(0).Modules
            If ModuleName = PM.ModuleName Then
                BaseAddress = PM.BaseAddress
                EndAddress = BaseAddress + PM.ModuleMemorySize
            End If
        Next
        If BaseAddress = 0 Then
            Return 0
            Exit Function
        End If
        Dim curAddr As Int32 = BaseAddress
        Do
            For i As Integer = 0 To Sig.Length - 1
                If Read_1Byte_32Bit(curAddr + i) = Sig(i) Then
                    If i = Sig.Length - 1 Then
                        Return curAddr
                    End If
                    Continue For
                End If
                Exit For
            Next
            curAddr += 1
        Loop While curAddr < EndAddress
        Return 0
    End Function
    Public Sub JmpToCave(ByVal DestinationAddi As Int32, ByVal sourceaddi As Int32, Optional ByVal NumberOfNops As Int32 = 0)
        Dim JmpBytes As Int32 = DestinationAddi - sourceaddi - 5
        Write_1Byte_64Bit(sourceaddi, &HE9)
        Write_4Byte_32Bit(sourceaddi + 1, JmpBytes)
        For i = 0 To NumberOfNops - 1
            Write_1Byte_64Bit(sourceaddi + 5 + i, &H90)
        Next
    End Sub
    Public Function GetJmpBytes(ByVal DestinationAddi As Int32, ByVal SourceAddi As Int32)
        Dim JmpBytes As Int32 = DestinationAddi - SourceAddi - 5
        Return JmpBytes
    End Function
#End Region

#Region "Converter"
    'Wandelt einen per Read_Long ausgelesenen Wert in eine Fließkommazahl um.
    Public Function Long2Float(ByVal Value As Int32)
        Dim floatnumber As Single
        Dim floatbytes() As Byte = BitConverter.GetBytes(Value)
        floatnumber = BitConverter.ToSingle(floatbytes, 0)
        Return floatnumber
    End Function
    'Wandelt eine Fließkommazahl in einen Integer Wert um, der dann wieder per Write_Pointer_Long/Write_Long geschrieben werden kann.
    Public Function Float2Long(ByVal Value As Single)
        Dim Longvalue As Int32
        Dim longbytes() As Byte = BitConverter.GetBytes(Value)
        Longvalue = BitConverter.ToInt32(longbytes, 0)
        Return Longvalue
    End Function
    'Wandelt einen Int64 in einen Double Wert um.
    Public Function Int64toDouble(ByVal Value As Int64)
        Dim doublevalue As Double
        Dim doublebytes() As Byte = BitConverter.GetBytes(Value)
        doublevalue = BitConverter.ToDouble(doublebytes, 0)
        Return doublevalue
    End Function
    'Wandelt einen Double Wert in einen Int64 Wert um, der dann wieder per Write_Pointer_8Bytes geschrieben werden kann.
    Public Function DoubletoInt64(ByVal Value As Double)
        Dim Int64number As Single
        Dim Int64bytes() As Byte = BitConverter.GetBytes(Value)
        Int64number = BitConverter.ToInt64(Int64bytes, 0)
        Return Int64number
    End Function
#End Region

#Region "Zusatzfunktionen"
    'Public Function UnicodeToString(ByVal str1 As String) As String
    '    'Dim str1 As String = Read_Pointer_String(56, BaseAddress_EXE + &H62E4FC, {&H9CC, &H1BA8, &HDA8})
    '    Dim char1() As Char = str1.ToCharArray
    '    Dim Text As New System.Text.StringBuilder
    '    Text = Text.Append("")
    '    For I As Integer = 0 To char1.Length - 1
    '        'MessageBox.Show(char1(I))
    '        'TextBox1.Text &= char1(I)
    '        Return Text.AppendLine(char1(I)).ToString
    '    Next
    'End Function
#End Region
End Module
